<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Kit;
use Elementor\Core\Kits\Documents\Tabs\Tab_Base;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Liquid_Global_Extras extends Tab_Base {

	public function __construct( $parent ) {
		parent::__construct( $parent );

		Controls_Manager::add_tab( $this->get_id(), $this->get_title() );
	}

	public function get_id() {
		return 'liquid-extras-kit';
	}

	public function get_title() {
		return __( 'Extras', 'logistics-hub-core' );
	}

	public function get_group() {
		return 'settings';
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_help_url() {
		return 'https://docs.liquid-themes.com/';
	}

	protected function register_tab_controls() {

		$this->start_controls_section(
			'section_' . $this->get_id() . '_custom_cursor',
			[
				'label' => esc_html__( 'Custom Cursor', 'logistics-hub-core' ),
				'tab' => $this->get_id(),
			]
		);

		$this->add_control(
			'liquid_stcu',
			[
				'label' => esc_html__( 'Custom cursor', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'liquid_stcu_active_parts',
			[
				'label' => esc_html__( 'Active parts', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => [
					'primary' => esc_html__( 'Primary', 'logistics-hub-core' ),
					'secondary' => esc_html__( 'Secondary', 'logistics-hub-core' ),
					'labeled-basic' => esc_html__( 'Basic labeled', 'logistics-hub-core' ),
					'labeled-arrow' => esc_html__( 'Arrow labeled', 'logistics-hub-core' ),
				],
				'default' => [ 'primary', 'secondary', 'labeled-basic', 'labeled-arrow' ],
				'condition' => [
					'liquid_stcu' => 'yes',
				],
			]
		);

		$this->add_control(
			'liquid_stcu_hide_system_cursor',
			[
				'label' => esc_html__( 'Hide system cursor?', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'condition' => [
					'liquid_stcu' => 'yes',
				],
				'selectors' => [
					'html:not(.elementor-html) :is(body, a, button, input, textarea, .lqd-carousel-is-draggable .lqd-carousel-viewport)' => 'cursor: none !important'
				]
			]
		);

		$this->add_control(
			'liquid_stcu_label_basic',
			[
				'label' => esc_html__( 'Label for basic cursor', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Explore', 'logistics-hub-core' ),
				'placeholder' => esc_html__( 'Explore', 'logistics-hub-core' ),
				'label_block' => true,
				'separator' => 'before',
				'conditions' => [
					'relation' => 'and',
					'terms' => [
						[
							'name' => 'liquid_stcu',
							'operator' => '===',
							'value' => 'yes',
						],
						[
							'name' => 'liquid_stcu_active_parts',
							'operator' => 'contains',
							'value' => 'labeled-basic',
						],
					],
				],
			]
		);

		$this->add_control(
			'liquid_stcu_label_arrow',
			[
				'label' => esc_html__( 'Label for arrow cursor', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Drag', 'logistics-hub-core' ),
				'placeholder' => esc_html__( 'Drag', 'logistics-hub-core' ),
				'label_block' => true,
				'conditions' => [
					'relation' => 'and',
					'terms' => [
						[
							'name' => 'liquid_stcu',
							'operator' => '===',
							'value' => 'yes',
						],
						[
							'name' => 'liquid_stcu_active_parts',
							'operator' => 'contains',
							'value' => 'labeled-arrow',
						],
					],
				],
			]
		);

		foreach ( ['primary', 'secondary', 'labeled'] as $cursor ) {

			$conditions = [
				'name' => 'liquid_stcu_active_parts',
				'operator' => 'contains',
				'value' => $cursor,
			];

			if ( $cursor === 'labeled' ) {
				$conditions = [
					'relation' => 'or',
					'terms' => [
						[
							'name' => 'liquid_stcu_active_parts',
							'operator' => 'contains',
							'value' => 'labeled-basic',
						],
						[
							'name' => 'liquid_stcu_active_parts',
							'operator' => 'contains',
							'value' => 'labeled-arrow',
						],
					]
				];
			}

			$this->add_control(
				'liquid_stcu_'. $cursor .'_styles_heading',
				[
					'label' => esc_html__( ucwords($cursor) .' styles', 'logistics-hub-core' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'conditions' => [
						'relation' => 'and',
						'terms' => [
							[
								'name' => 'liquid_stcu',
								'operator' => '===',
								'value' => 'yes',
							],
							$conditions
						],
					],
				]
			);

			if ( $cursor === 'labeled' ) {
				$this->add_control(
					'liquid_stcu_'. $cursor .'_color',
					[
						'label' => esc_html__( 'Color', 'logistics-hub-core' ),
						'type' => 'liquid-color',
						'types' => [ 'solid' ],
						'selectors' => [
							'{{WRAPPER}}' => '--lqd-stcu-'. $cursor .'-c: {{VALUE}};',
						],
						'conditions' => [
							'relation' => 'and',
							'terms' => [
								[
									'name' => 'liquid_stcu',
									'operator' => '===',
									'value' => 'yes',
								],
								$conditions
							],
						],
					]
				);
			}

			$this->add_group_control(
			   'liquid-background-css',
				[
					'name' => 'liquid_stcu_'. $cursor .'_bg',
					'label' => esc_html__( 'Background', 'logistics-hub-core' ),
					'css_attr' => '--lqd-stcu-'. $cursor .'-bg',
					'selector' => '{{WRAPPER}}',
					'conditions' => [
						'relation' => 'and',
						'terms' => [
							[
								'name' => 'liquid_stcu',
								'operator' => '===',
								'value' => 'yes',
							],
							$conditions
						],
					],
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'liquid_stcu_'. $cursor .'_border',
					'label' => esc_html__( 'Border', 'logistics-hub-core' ),
					'selector' => '{{WRAPPER}}',
					'fields_options' => [
						'color' => [
							'type' => 'liquid-color',
							'types' => [ 'solid' ],
							'selectors' => [
								'{{SELECTOR}}' => '--lqd-stcu-'. $cursor .'-brc: {{VALUE}};',
							],
						],
						'border' => [
							'selectors' => [
								'{{SELECTOR}}' => '--lqd-stcu-'. $cursor .'-brs: {{VALUE}};',
							],
						],
						'width' => [
							'selectors' => [
								'{{SELECTOR}}' => '--lqd-stcu-'. $cursor .'-brw: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
							],
						],
					],
					'conditions' => [
						'relation' => 'and',
						'terms' => [
							[
								'name' => 'liquid_stcu',
								'operator' => '===',
								'value' => 'yes',
							],
							$conditions
						],
					],
				]
			);

			$this->add_control(
				'liquid_stcu_'. $cursor .'_border_radius',
				[
					'label' => esc_html__( 'Border radius', 'logistics-hub-core' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}}' => '--lqd-stcu-'. $cursor .'-brrt: {{TOP}}{{UNIT}}; --lqd-stcu-'. $cursor .'-brre: {{RIGHT}}{{UNIT}}; --lqd-stcu-'. $cursor .'-brrb: {{BOTTOM}}{{UNIT}}; --lqd-stcu-'. $cursor .'-brrs: {{LEFT}}{{UNIT}};',
					],
					'conditions' => [
						'relation' => 'and',
						'terms' => [
							[
								'name' => 'liquid_stcu',
								'operator' => '===',
								'value' => 'yes',
							],
							$conditions
						],
					],
				]
			);

			$this->add_control(
				'liquid_stcu_'. $cursor .'_dimensions',
				[
					'label' => esc_html__( 'Dimension', 'logistics-hub-core' ),
					'type' => 'liquid-linked-dimensions',
					'selectors' => [
						'{{WRAPPER}}' => '--lqd-stcu-'. $cursor .'-w: {{WIDTH}}{{UNIT}}; --lqd-stcu-'. $cursor .'-h: {{HEIGHT}}{{UNIT}};'
					],
					'conditions' => [
						'relation' => 'and',
						'terms' => [
							[
								'name' => 'liquid_stcu',
								'operator' => '===',
								'value' => 'yes',
							],
							$conditions
						],
					],
				]
			);

		}

		$this->add_control(
			'liquid_stcu_blend_mode',
			[
				'label' => esc_html__( 'Blend Mode', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'normal',
				'options' => [
					'normal' => esc_html__( 'Normal', 'logistics-hub-core' ),
					'multiply' => esc_html__( 'Multiply', 'logistics-hub-core' ),
					'screen' => esc_html__( 'Screen', 'logistics-hub-core' ),
					'overlay' => esc_html__( 'Overlay', 'logistics-hub-core' ),
					'darken' => esc_html__( 'Darken', 'logistics-hub-core' ),
					'lighten' => esc_html__( 'Lighten', 'logistics-hub-core' ),
					'color-dodge' => esc_html__( 'Color Dodge', 'logistics-hub-core' ),
					'color-burn' => esc_html__( 'Color Burn', 'logistics-hub-core' ),
					'hard-light' => esc_html__( 'Hard Light', 'logistics-hub-core' ),
					'soft-light' => esc_html__( 'Soft Light', 'logistics-hub-core' ),
					'difference' => esc_html__( 'Difference', 'logistics-hub-core' ),
					'exclusion' => esc_html__( 'Exclusion', 'logistics-hub-core' ),
					'hue' => esc_html__( 'Hue', 'logistics-hub-core' ),
					'saturation' => esc_html__( 'Saturation', 'logistics-hub-core' ),
					'color' => esc_html__( 'Color', 'logistics-hub-core' ),
					'luminosity' => esc_html__( 'Luminosity', 'logistics-hub-core' ),
				],
				'selectors' => [
					'{{WRAPPER}} .lqd-global-stcu-wrap' => 'mix-blend-mode: {{VALUE}}',
				],
				'separator' => 'before',
				'condition' => [
					'liquid_stcu' => 'yes',
				],
			]
		);

		$this->end_controls_section();

		/*
		 *
		 * Local Scroll
		 *
		 */
		$this->start_controls_section(
			'section_' . $this->get_id() . '_localscroll',
			[
				'label' => esc_html__( 'Local Scroll', 'logistics-hub-core' ),
				'tab' => $this->get_id(),
			]
		);

		$this->add_control(
			'liquid_localscroll_speed',
			[
				'label' => esc_html__( 'Local scroll speed (second)', 'logistics-hub-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 0.1,
					],
				]
			]
		);

		$this->add_control(
			'liquid_localscroll_offset',
			[
				'label' => esc_html__( 'Local scroll offset (px)', 'logistics-hub-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
						'step' => 1,
					],
				],
			]
		);

		$this->end_controls_section();

		/*
		 *
		 * 404
		 *
		 */

		$this->start_controls_section(
			'section_' . $this->get_id() . '_404',
			[
				'label' => esc_html__( '404 page', 'logistics-hub-core' ),
				'tab' => $this->get_id(),
			]
		);

		$this->add_control(
			'liquid_error_404_title',
			[
				'label' => esc_html__( 'Title', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '404', 'logistics-hub-core' ),
				'placeholder' => esc_html__( 'Type your title here', 'logistics-hub-core' ),
			]
		);

		$this->add_control(
			'liquid_error_404_subtitle',
			[
				'label' => esc_html__( 'Heading', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Looks like you are lost', 'logistics-hub-core' ),
				'placeholder' => esc_html__( 'Type your subtitle here', 'logistics-hub-core' ),
			]
		);

		$this->add_control(
			'liquid_error_404_content',
			[
				'label' => esc_html__( 'Content', 'logistics-hub-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'We can’t seem to find the page you’re looking for.', 'logistics-hub-core' ),
				'placeholder' => esc_html__( 'Type your content here', 'logistics-hub-core' ),
			]
		);

		$this->add_control(
			'liquid_error_404_enable_btn',
			[
				'label' => esc_html__( 'Button', 'logistics-hub-core' ),
				'description' => esc_html__( 'Switch on to display the "back to home" button.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'On', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Off', 'logistics-hub-core' ),
				'return_value' => 'on',
				'default' => 'on',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'liquid_error_404_btn_title',
			[
				'label' => esc_html__( 'Button Title', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Back to home', 'logistics-hub-core' ),
				'condition' => [
					'liquid_error_404_enable_btn' => 'on',
				],
			]
		);

		$this->end_controls_section();

	}

}

new Liquid_Global_Extras( Kit::class );

add_action(
	'elementor/kit/register_tabs',
	function( $kit ) {
		$kit->register_tab( 'liquid-extras-kit', Liquid_Global_Extras::class );
	}
);
